/*
 * ValidarAction.java
 *
 * Created on 6 de noviembre de 2007, 13:12
 */

package servlets;

import javax.servlet.http.*;
import org.apache.struts.action.*;
import modelo.*;
import javabeans.*;
public class ValidarAction extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm  form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        //obtiene los datos del driver y de la cadena de conexin
        //de los parmetros de contexto definidos en Web.xml
        String driver=this.getServlet().getServletContext().getInitParameter("driver");
        String cadenaCon=this.getServlet().getServletContext().getInitParameter("cadenaCon");
        GestionClientes gc=new GestionClientes(driver,cadenaCon);
        ValidacionForm vf=(ValidacionForm)form;
        if(gc.validar(vf)){
            GestionTelefonos gt=new GestionTelefonos(driver,cadenaCon);
            //recupera los nmeros asociados al password y los almacena
            //en el bean ValidacionForm para que puedan ser accesibles
            //a la vista "bienvenida"
            vf.setTelefonos(gt.getTelefonos(vf.getPassword()));
            return mapping.findForward("bienvenida");
        }
        else{
            vf.setMensaje("<h2>Combinacin de usuario y password incorrecta!</h2>");
            return mapping.findForward("error");
        }       
    }
}
